#!/bin/sh

BASE="/usr/local/bin/mmdvmhost"
INI="$BASE/MMDVM.ini"
DMR="$BASE/DMRIds.dat"
URL="https://fdmr.dynbox.net/pistar/DMRIds.dat"

# --- Dummy-Abschnitt: hier kannst du später Dateien herunterladen ---
# Beispiel:
# wget -O "$BASE/update.bin" https://example.com/update
# chmod +x "$BASE/update.bin"
# echo "Downloads abgeschlossen"


# --- DMRIds.dat prüfen und ggf. herunterladen ---
NEED_DOWNLOAD=0

# Datei fehlt?
if [ ! -f "$DMR" ]; then
    echo "DMRIds.dat fehlt – lade herunter..."
    NEED_DOWNLOAD=1
else
    # Datei älter als 8 Stunden?
    NOW=$(date +%s)
    FILETIME=$(stat -c %Y "$DMR")
    AGE=$((NOW - FILETIME))

    if [ $AGE -gt 28800 ]; then   # 8h = 28800 Sekunden
        echo "DMRIds.dat ist älter als 8 Stunden – lade neu herunter..."
        NEED_DOWNLOAD=1
    fi
fi

if [ $NEED_DOWNLOAD -eq 1 ]; then
    wget -q -O "$DMR" "$URL"
    if [ $? -eq 0 ]; then
        echo "DMRIds.dat erfolgreich aktualisiert."
    else
        echo "WARNUNG: Konnte DMRIds.dat nicht herunterladen."
    fi
fi


# --- PHP Built-in Server starten, falls nicht bereits aktiv ---
PHP_PORT=80

if ! pgrep -f "php -S 0.0.0.0:${PHP_PORT}" >/dev/null 2>&1; then
    echo "Starte PHP-Server auf Port ${PHP_PORT}..."
    cd "$BASE"
    nohup php -S 0.0.0.0:${PHP_PORT} >/dev/null 2>&1 &
else
    echo "PHP-Server läuft bereits."
fi


# --- Prüfen, ob MMDVM.ini existiert ---
if [ ! -f "$INI" ]; then
    echo "FEHLER: $INI wurde nicht gefunden. MMDVMHost wird nicht gestartet."
    exit 1
fi


# --- Start von MMDVMHost ---
cd "$BASE"
exec "$BASE/MMDVMHost" "$INI"
